<?php
/**
 * Public Error Page — Pastel Scrapbook Style (Single-screen, no scroll)
 * Variables: $appName, $faviconUrl, $errorType
 */
$errorMessages = [
    'not_found' => [
        'emoji' => '🔍',
        'title' => 'Tidak Ditemukan',
        'message' => 'File atau folder yang Anda cari tidak ditemukan. Mungkin sudah dihapus, dipindahkan, atau tautan sudah tidak aktif.',
    ],
    'file_not_in_folder' => [
        'emoji' => '📂',
        'title' => 'File Tidak Ditemukan',
        'message' => 'File yang diminta tidak ada dalam folder ini. Mungkin sudah dipindahkan atau dihapus.',
    ],
];

$err = $errorMessages[$errorType] ?? $errorMessages['not_found'];
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($err['title']) ?> — <?= htmlspecialchars($appName) ?></title>
    <link rel="icon" type="image/svg+xml" href="<?= htmlspecialchars($faviconUrl) ?>">
    <style>
        :root {
            --bg-start:#f0e6ff;--bg-end:#fce4ec;--bg-grid:rgba(180,160,210,0.18);
            --panel:#fffbfe;--panel-alt:#f8f0ff;--ink:#3d2c5e;--ink-secondary:#6b5a8a;
            --ink-muted:#9a8bb5;--border:#7c6b9e;--border-soft:#c4b5de;--border-faint:#e4daf0;
            --accent:#9b6dd7;--accent-hover:#8a5bc8;--accent-text:#fff;--accent-soft:#ede0ff;
            --pink:#e879a8;--teal:#5bbcb4;--danger:#d94f5c;--danger-bg:#ffeaec;
            --shadow-card:3px 3px 0px #7c6b9e;--shadow-btn:2px 2px 0px #7c6b9e;
            --taskbar-bg:linear-gradient(135deg,#9b6dd7,#e879a8);
        }
        @media(prefers-color-scheme:dark){:root{
            --bg-start:#1a1028;--bg-end:#0f1a24;--bg-grid:rgba(120,90,200,0.08);
            --panel:#231838;--panel-alt:#2c2044;--ink:#e8dcff;--ink-secondary:#c4b5de;
            --ink-muted:#8a7aaa;--border:#7a60b0;--border-soft:#4a3870;--border-faint:#352650;
            --accent:#b48aef;--accent-hover:#c9a5ff;--accent-text:#1a1028;--accent-soft:#352660;
            --pink:#ff7eb3;--teal:#56d4c8;--danger:#ff6b7a;--danger-bg:#3a1520;
            --shadow-card:3px 3px 0px rgba(0,0,0,0.5);--shadow-btn:2px 2px 0px rgba(0,0,0,0.5);
            --taskbar-bg:linear-gradient(135deg,#352660,#3a1a2a);
        }}
        *{margin:0;padding:0;box-sizing:border-box}
        html,body{height:100%;overflow:hidden}
        body{font-family:'Segoe UI',system-ui,sans-serif;color:var(--ink);font-size:14px;line-height:1.5;
            display:flex;flex-direction:column;
            background:linear-gradient(135deg,var(--bg-start),var(--bg-end));background-attachment:fixed}
        body::before{content:'';position:fixed;inset:0;
            background-image:linear-gradient(var(--bg-grid) 1px,transparent 1px),linear-gradient(90deg,var(--bg-grid) 1px,transparent 1px);
            background-size:24px 24px;pointer-events:none;z-index:0}
        .main{flex:1;display:flex;align-items:center;justify-content:center;padding:16px;position:relative;z-index:1}
        .window-card{background:var(--panel);border:2px solid var(--border);box-shadow:var(--shadow-card);border-radius:12px;overflow:hidden;width:100%;max-width:420px;position:relative}
        .window-header{background:linear-gradient(135deg,var(--danger),var(--pink));padding:8px 12px;display:flex;align-items:center;gap:8px;border-bottom:2px solid var(--border);min-height:34px}
        .window-dots{display:flex;gap:5px}
        .dot{width:10px;height:10px;border-radius:50%;border:1.5px solid rgba(0,0,0,0.2)}
        .dot-r{background:#ff6b6b}.dot-y{background:#ffd93d}.dot-g{background:#6bcb77}
        .window-title{flex:1;font-weight:700;font-size:13px;color:#fff;text-shadow:0 1px 2px rgba(0,0,0,0.2);white-space:nowrap;overflow:hidden;text-overflow:ellipsis}
        .window-body{padding:24px;text-align:center}
        .error-emoji{font-size:56px;margin-bottom:12px;display:block}
        .error-title{font-weight:700;font-size:18px;margin-bottom:8px;color:var(--ink)}
        .error-message{font-size:13px;color:var(--ink-muted);line-height:1.6;margin-bottom:20px;max-width:320px;margin-left:auto;margin-right:auto}
        .error-hints{background:var(--panel-alt);border:1.5px dashed var(--border-faint);border-radius:8px;padding:12px;margin-bottom:20px;text-align:left;font-size:11px;color:var(--ink-secondary)}
        .error-hints ul{list-style:none;padding:0;margin:0}
        .error-hints li{padding:3px 0;display:flex;align-items:center;gap:6px}
        .error-hints li::before{content:'•';color:var(--accent);font-weight:bold}
        .error-code{display:inline-flex;padding:2px 10px;font-size:10px;font-weight:700;text-transform:uppercase;letter-spacing:1px;border-radius:6px;border:1.5px solid var(--border-soft);background:var(--panel-alt);color:var(--ink-muted);margin-bottom:16px}
        .sparkle{position:absolute;pointer-events:none;opacity:0.1}
        .footer-bar{padding:6px 16px;text-align:center;font-size:10px;color:var(--ink-muted);border-top:1px dashed var(--border-faint);background:var(--panel-alt)}

        .taskbar{flex-shrink:0;background:var(--taskbar-bg);border-top:2px solid var(--border);padding:6px 12px;display:flex;align-items:center;gap:8px;position:relative;z-index:1}
        .taskbar-brand{font-weight:700;font-size:12px;color:#fff;text-shadow:0 1px 2px rgba(0,0,0,0.2);display:flex;align-items:center;gap:4px}
        .taskbar-spacer{flex:1}
        .taskbar-btn{background:rgba(255,255,255,0.15);border:1.5px solid rgba(255,255,255,0.25);color:#fff;padding:4px 10px;border-radius:6px;font-size:11px;font-weight:600;cursor:pointer;font-family:inherit;display:flex;align-items:center;gap:4px;transition:background 0.1s}
        .taskbar-btn:hover{background:rgba(255,255,255,0.25)}
    </style>
</head>
<body>
    <div class="main">
        <div class="window-card">
            <span class="sparkle" style="top:-10px;right:18px;font-size:24px">✦</span>
            <span class="sparkle" style="bottom:-6px;left:12px;font-size:18px">✧</span>
            <div class="window-header">
                <div class="window-dots"><div class="dot dot-r"></div><div class="dot dot-y"></div><div class="dot dot-g"></div></div>
                <div class="window-title">⚠️ <?= htmlspecialchars($appName) ?> — <?= htmlspecialchars($err['title']) ?></div>
            </div>
            <div class="window-body">
                <span class="error-emoji"><?= $err['emoji'] ?></span>
                <div class="error-code">ERROR 404</div>
                <div class="error-title"><?= htmlspecialchars($err['title']) ?></div>
                <div class="error-message"><?= htmlspecialchars($err['message']) ?></div>
                <div class="error-hints">
                    <div style="font-weight:700;margin-bottom:6px">Kemungkinan penyebab:</div>
                    <ul>
                        <li>File atau folder telah dihapus oleh pemilik</li>
                        <li>Tautan berbagi telah dinonaktifkan</li>
                        <li>File dipindahkan ke lokasi lain</li>
                        <li>URL yang dimasukkan salah atau tidak lengkap</li>
                    </ul>
                </div>
            </div>
            <div class="footer-bar">✦ <?= htmlspecialchars($appName) ?> ✦</div>
        </div>
    </div>

    <div class="taskbar">
        <div class="taskbar-brand">📁 <?= htmlspecialchars($appName) ?></div>
        <div class="taskbar-spacer"></div>
        <button class="taskbar-btn" onclick="toggleTheme()" id="themeBtn">🌙 Mode Gelap</button>
    </div>

    <script>
    function toggleTheme(){
        var d=document.documentElement;
        var dark=d.getAttribute('data-theme')==='dark';
        d.setAttribute('data-theme',dark?'light':'dark');
        document.getElementById('themeBtn').textContent=dark?'🌙 Mode Gelap':'☀️ Mode Terang';
        localStorage.setItem('sfiles_pub_theme',dark?'light':'dark');
    }
    (function(){
        var s=localStorage.getItem('sfiles_pub_theme');
        if(s==='dark'){document.documentElement.setAttribute('data-theme','dark');document.getElementById('themeBtn').textContent='☀️ Mode Terang';}
    })();
    </script>
</body>
</html>
