<?php
/**
 * Public Share Page — Pastel Scrapbook Style (SINGLE-SCREEN, comfortable sizing)
 * Variables: $file|$folder, $folderFiles, $previewUrl, $downloadBase, $appName, $mime,
 *            $ogImageUrl, $pageUrl, $faviconUrl, $isFolder, $token
 */
function _hs(int $bytes): string {
    if ($bytes === 0) return '0 B';
    $u = ['B','KB','MB','GB','TB']; $i = 0; $v = (float)$bytes;
    while ($v >= 1024 && $i < 4) { $v /= 1024; $i++; }
    return round($v, 1) . ' ' . $u[$i];
}

$token = $token ?? ($file['shared_token'] ?? $folder['shared_token'] ?? '');

if ($isFolder) {
    $eName = htmlspecialchars($folder['name'], ENT_QUOTES, 'UTF-8');
    $eSize = count($folderFiles) . ' file';
    $totalBytes = 0;
    foreach ($folderFiles as $ff) { $totalBytes += (int)$ff['size_bytes']; }
    $eTotalSize = _hs($totalBytes);
    $eDate = date('d M Y', strtotime($folder['created_at']));
    $emoji = '📁'; $ext = 'FOLDER';
} else {
    $eName = htmlspecialchars($file['display_name'], ENT_QUOTES, 'UTF-8');
    $eMime = htmlspecialchars($file['mime_type'], ENT_QUOTES, 'UTF-8');
    $eSize = _hs((int)$file['size_bytes']);
    $eDate = date('d M Y, H:i', strtotime($file['created_at']));
    $isImage = str_starts_with($mime, 'image/');
    $isPdf = ($mime === 'application/pdf');
    $isVideo = str_starts_with($mime, 'video/');
    $isAudio = str_starts_with($mime, 'audio/');
    $ext = strtoupper(pathinfo($file['display_name'], PATHINFO_EXTENSION));
    if (!$ext) $ext = 'FILE';
    $emoji = '📎';
    if ($isImage) $emoji = '🖼️';
    elseif ($isPdf) $emoji = '📕';
    elseif ($isVideo) $emoji = '🎬';
    elseif ($isAudio) $emoji = '🎵';
}

$ogDescription = $isFolder
    ? "📁 {$eName} ({$eSize}) — Folder dibagikan dari " . htmlspecialchars($appName)
    : "📁 {$eName} ({$eSize}) — Unduh file ini dari " . htmlspecialchars($appName);

$appUrl = CONFIG['APP_URL'] . CONFIG['BASE_PATH'];
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $eName ?> — <?= htmlspecialchars($appName) ?></title>
    <link rel="icon" type="image/svg+xml" href="<?= htmlspecialchars($faviconUrl) ?>">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?= htmlspecialchars($pageUrl) ?>">
    <meta property="og:title" content="<?= $eName ?> — <?= htmlspecialchars($appName) ?>">
    <meta property="og:description" content="<?= $ogDescription ?>">
    <meta property="og:image" content="<?= htmlspecialchars($ogImageUrl) ?>">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?= $eName ?> — <?= htmlspecialchars($appName) ?>">
    <meta name="twitter:description" content="<?= $ogDescription ?>">
    <meta name="twitter:image" content="<?= htmlspecialchars($ogImageUrl) ?>">
    <meta name="description" content="<?= $ogDescription ?>">
    <style>
        :root {
            --bg-start:#f0e6ff;--bg-end:#fce4ec;--bg-grid:rgba(180,160,210,0.15);
            --panel:#fffbfe;--panel-alt:#f8f0ff;--ink:#3d2c5e;--ink-secondary:#6b5a8a;
            --ink-muted:#9a8bb5;--border:#7c6b9e;--border-soft:#c4b5de;--border-faint:#e4daf0;
            --accent:#9b6dd7;--accent-hover:#8a5bc8;--accent-text:#fff;--accent-soft:#ede0ff;
            --pink:#e879a8;--teal:#5bbcb4;
            --shadow-card:4px 4px 0px #7c6b9e;--shadow-btn:3px 3px 0px #7c6b9e;
            --taskbar-bg:linear-gradient(135deg,#9b6dd7,#e879a8);
        }
        [data-theme="dark"],
        @media(prefers-color-scheme:dark){:root:not([data-theme="light"]){
            --bg-start:#1a1028;--bg-end:#0f1a24;--bg-grid:rgba(120,90,200,0.08);
            --panel:#231838;--panel-alt:#2c2044;--ink:#e8dcff;--ink-secondary:#c4b5de;
            --ink-muted:#8a7aaa;--border:#7a60b0;--border-soft:#4a3870;--border-faint:#352650;
            --accent:#b48aef;--accent-hover:#c9a5ff;--accent-text:#1a1028;--accent-soft:#352660;
            --pink:#ff7eb3;--teal:#56d4c8;
            --shadow-card:4px 4px 0px rgba(0,0,0,0.5);--shadow-btn:3px 3px 0px rgba(0,0,0,0.5);
            --taskbar-bg:linear-gradient(135deg,#352660,#3a1a2a);
        }}
        [data-theme="dark"]{
            --bg-start:#1a1028;--bg-end:#0f1a24;--bg-grid:rgba(120,90,200,0.08);
            --panel:#231838;--panel-alt:#2c2044;--ink:#e8dcff;--ink-secondary:#c4b5de;
            --ink-muted:#8a7aaa;--border:#7a60b0;--border-soft:#4a3870;--border-faint:#352650;
            --accent:#b48aef;--accent-hover:#c9a5ff;--accent-text:#1a1028;--accent-soft:#352660;
            --pink:#ff7eb3;--teal:#56d4c8;
            --shadow-card:4px 4px 0px rgba(0,0,0,0.5);--shadow-btn:3px 3px 0px rgba(0,0,0,0.5);
            --taskbar-bg:linear-gradient(135deg,#352660,#3a1a2a);
        }
        *{margin:0;padding:0;box-sizing:border-box}
        html,body{height:100%;overflow:hidden}
        body{font-family:'Segoe UI',system-ui,sans-serif;color:var(--ink);font-size:15px;line-height:1.6;
            display:flex;flex-direction:column;
            background:linear-gradient(135deg,var(--bg-start),var(--bg-end));background-attachment:fixed}
        body::before{content:'';position:fixed;inset:0;
            background-image:linear-gradient(var(--bg-grid) 1px,transparent 1px),linear-gradient(90deg,var(--bg-grid) 1px,transparent 1px);
            background-size:28px 28px;pointer-events:none;z-index:0}

        .main{flex:1;display:flex;align-items:center;justify-content:center;padding:16px;position:relative;z-index:1;min-height:0}
        .window-card{background:var(--panel);border:2.5px solid var(--border);box-shadow:var(--shadow-card);border-radius:14px;overflow:hidden;width:100%;max-width:560px;display:flex;flex-direction:column;max-height:100%;position:relative}
        .window-header{background:linear-gradient(135deg,var(--accent),var(--pink));padding:10px 16px;display:flex;align-items:center;gap:10px;border-bottom:2.5px solid var(--border);min-height:44px;flex-shrink:0}
        .window-dots{display:flex;gap:6px}
        .dot{width:12px;height:12px;border-radius:50%;border:1.5px solid rgba(0,0,0,0.2)}
        .dot-r{background:#ff6b6b}.dot-y{background:#ffd93d}.dot-g{background:#6bcb77}
        .window-title{flex:1;font-weight:700;font-size:14px;color:#fff;text-shadow:0 1px 3px rgba(0,0,0,0.2);white-space:nowrap;overflow:hidden;text-overflow:ellipsis}
        .window-body{padding:20px;flex:1;overflow-y:auto;min-height:0}
        .window-body::-webkit-scrollbar{width:8px}
        .window-body::-webkit-scrollbar-track{background:transparent}
        .window-body::-webkit-scrollbar-thumb{background:var(--border-soft);border-radius:4px}

        .preview-area{background:var(--panel-alt);border:2.5px solid var(--border-faint);border-radius:10px;overflow:hidden;display:flex;align-items:center;justify-content:center;margin-bottom:16px}
        .preview-area img{max-width:100%;max-height:260px;object-fit:contain;display:block}
        .preview-area iframe{width:100%;height:300px;border:none}

        .file-info{background:var(--panel-alt);border:2px solid var(--border-faint);border-radius:10px;padding:16px;margin-bottom:16px}
        .file-name{font-weight:700;font-size:16px;word-break:break-all;margin-bottom:8px}
        .file-meta{display:flex;flex-wrap:wrap;gap:12px;font-size:13px;color:var(--ink-muted)}
        .file-meta span{display:flex;align-items:center;gap:4px}
        .badge{display:inline-flex;padding:2px 8px;font-size:11px;font-weight:700;text-transform:uppercase;letter-spacing:0.5px;border-radius:6px;border:2px solid var(--accent);background:var(--accent-soft);color:var(--accent)}

        .btn-download{display:inline-flex;align-items:center;justify-content:center;gap:10px;width:100%;padding:14px 24px;font-size:16px;font-weight:700;font-family:inherit;color:var(--accent-text);background:var(--accent);border:2.5px solid var(--accent-hover);border-radius:12px;cursor:pointer;text-decoration:none;box-shadow:var(--shadow-btn);transition:transform 0.1s,box-shadow 0.1s}
        .btn-download:hover{background:var(--accent-hover)}
        .btn-download:active{transform:translate(3px,3px);box-shadow:0 0 0}

        .folder-files{border:2px solid var(--border-faint);border-radius:10px;margin-bottom:16px;overflow:hidden}
        .folder-files-header{background:var(--panel-alt);padding:10px 16px;font-weight:700;font-size:13px;border-bottom:1.5px solid var(--border-faint);display:flex;align-items:center;gap:8px}
        .folder-files-list{max-height:220px;overflow-y:auto}
        .folder-files-list::-webkit-scrollbar{width:6px}
        .folder-files-list::-webkit-scrollbar-track{background:transparent}
        .folder-files-list::-webkit-scrollbar-thumb{background:var(--border-soft);border-radius:3px}
        .folder-file-row{display:flex;align-items:center;gap:10px;padding:10px 16px;border-bottom:1.5px dashed var(--border-faint);font-size:13px;transition:background 0.1s}
        .folder-file-row:last-child{border-bottom:none}
        .folder-file-row:hover{background:var(--panel-alt)}
        .folder-file-name{flex:1;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;font-weight:500}
        .folder-file-size{color:var(--ink-muted);flex-shrink:0;font-size:12px}
        .btn-dl-small{background:var(--accent);color:var(--accent-text);border:2px solid var(--accent-hover);border-radius:8px;padding:4px 12px;font-size:12px;font-weight:600;cursor:pointer;font-family:inherit;text-decoration:none;display:inline-flex;align-items:center;gap:4px;box-shadow:2px 2px 0 var(--border);transition:transform 0.1s,box-shadow 0.1s;flex-shrink:0}
        .btn-dl-small:hover{background:var(--accent-hover)}
        .btn-dl-small:active{transform:translate(2px,2px);box-shadow:0 0 0}

        .notice{font-size:12px;color:var(--ink-muted);text-align:center;margin-top:12px;padding:10px;background:var(--panel-alt);border:1.5px dashed var(--border-faint);border-radius:8px}
        .footer-bar{padding:8px 20px;text-align:center;font-size:11px;color:var(--ink-muted);border-top:1.5px dashed var(--border-faint);background:var(--panel-alt);flex-shrink:0}

        .taskbar{flex-shrink:0;background:var(--taskbar-bg);border-top:2.5px solid var(--border);padding:8px 16px;display:flex;align-items:center;gap:10px;position:relative;z-index:1}
        .taskbar-brand{font-weight:700;font-size:13px;color:#fff;text-shadow:0 1px 3px rgba(0,0,0,0.2);display:flex;align-items:center;gap:6px}
        .taskbar-spacer{flex:1}
        .taskbar-btn{background:rgba(255,255,255,0.15);border:2px solid rgba(255,255,255,0.25);color:#fff;padding:6px 14px;border-radius:8px;font-size:13px;font-weight:600;cursor:pointer;font-family:inherit;display:flex;align-items:center;gap:6px;transition:background 0.1s}
        .taskbar-btn:hover{background:rgba(255,255,255,0.25)}

        .sparkle{position:absolute;pointer-events:none;opacity:0.1}

        @media(max-height:600px){
            .preview-area img{max-height:160px}
            .preview-area iframe{height:200px}
            .folder-files-list{max-height:140px}
            .window-body{padding:14px}
        }
        @media(max-width:500px){
            .main{padding:10px;padding-top:16px}
        }
    </style>
</head>
<body>
    <div class="main">
        <div class="window-card">
            <span class="sparkle" style="top:-12px;right:20px;font-size:28px">✦</span>
            <span class="sparkle" style="bottom:-8px;left:14px;font-size:22px">✧</span>
            <div class="window-header">
                <div class="window-dots"><div class="dot dot-r"></div><div class="dot dot-y"></div><div class="dot dot-g"></div></div>
                <div class="window-title"><?= $isFolder ? '📁' : '📄' ?> <?= htmlspecialchars($appName) ?> — <?= $isFolder ? 'Folder Bersama' : 'Unduh File' ?></div>
            </div>
            <div class="window-body">
                <?php if (!$isFolder): ?>
                    <?php if (!empty($isImage) && $previewUrl): ?>
                    <div class="preview-area" style="padding:8px"><img src="<?= htmlspecialchars($previewUrl) ?>" alt="<?= $eName ?>" loading="lazy"></div>
                    <?php elseif (!empty($isPdf) && $previewUrl): ?>
                    <div class="preview-area"><iframe src="<?= htmlspecialchars($previewUrl) ?>" title="PDF"></iframe></div>
                    <?php else: ?>
                    <div class="preview-area" style="flex-direction:column;gap:8px;padding:32px">
                        <span style="font-size:48px"><?= $emoji ?></span><span class="badge"><?= $ext ?></span>
                    </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="preview-area" style="flex-direction:column;gap:8px;padding:32px">
                        <span style="font-size:48px">📁</span><span class="badge">FOLDER</span>
                    </div>
                <?php endif; ?>

                <div class="file-info">
                    <div class="file-name"><?= $eName ?></div>
                    <div class="file-meta">
                        <span>📏 <?= $eSize ?><?= $isFolder ? " ({$eTotalSize})" : '' ?></span>
                        <span>📅 <?= $eDate ?></span>
                        <span class="badge"><?= $ext ?></span>
                    </div>
                </div>

                <?php if (!$isFolder): ?>
                    <a href="<?= htmlspecialchars($downloadBase) ?>" class="btn-download">💾 Unduh File</a>
                <?php endif; ?>

                <?php if ($isFolder): ?>
                    <?php if (!empty($folderFiles)): ?>
                    <div class="folder-files">
                        <div class="folder-files-header">📋 File dalam folder (<?= count($folderFiles) ?>)</div>
                        <div class="folder-files-list">
                            <?php foreach ($folderFiles as $ff): ?>
                            <div class="folder-file-row">
                                <span>📄</span>
                                <span class="folder-file-name"><?= htmlspecialchars($ff['display_name']) ?></span>
                                <span class="folder-file-size"><?= _hs((int)$ff['size_bytes']) ?></span>
                                <a href="<?= htmlspecialchars($appUrl . '/s/' . $token . '/download/' . $ff['id']) ?>" class="btn-dl-small">💾 Unduh</a>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php else: ?>
                    <div style="text-align:center;padding:24px;color:var(--ink-muted);font-size:14px">
                        📂 Folder ini kosong.
                    </div>
                    <?php endif; ?>
                <?php endif; ?>

                <div class="notice">⚠ Tautan publik — siapa pun yang memiliki tautan ini dapat mengakses konten ini.</div>
            </div>
            <div class="footer-bar">✦ Dibagikan melalui <?= htmlspecialchars($appName) ?> ✦</div>
        </div>
    </div>

    <div class="taskbar">
        <div class="taskbar-brand">📁 <?= htmlspecialchars($appName) ?></div>
        <div class="taskbar-spacer"></div>
        <button class="taskbar-btn" onclick="toggleTheme()" id="themeBtn">🌙 Gelap</button>
    </div>

    <script>
    function toggleTheme(){
        var d=document.documentElement;
        var isDark=d.getAttribute('data-theme')==='dark';
        d.setAttribute('data-theme',isDark?'light':'dark');
        document.getElementById('themeBtn').textContent=isDark?'🌙 Gelap':'☀️ Terang';
        localStorage.setItem('sfiles_pub_theme',isDark?'light':'dark');
    }
    (function(){
        var s=localStorage.getItem('sfiles_pub_theme');
        if(s==='dark'){
            document.documentElement.setAttribute('data-theme','dark');
            document.getElementById('themeBtn').textContent='☀️ Terang';
        } else if(s==='light'){
            document.documentElement.setAttribute('data-theme','light');
        }
    })();
    </script>
</body>
</html>
