<?php
/**
 * Syamsu Files (SFiles) - Front Controller
 */
declare(strict_types=1);
error_reporting(E_ALL);
ini_set('display_errors', '0');

define('ROOT_PATH', dirname(__DIR__));

$config = require ROOT_PATH . '/config/config.php';
define('CONFIG', $config);

spl_autoload_register(function (string $class) {
    $prefix = 'App\\';
    if (strncmp($class, $prefix, strlen($prefix)) !== 0) return;
    $relative = substr($class, strlen($prefix));
    $file = ROOT_PATH . '/app/' . str_replace('\\', '/', $relative) . '.php';
    if (file_exists($file)) require $file;
});

\App\Core\DB::init();

$secure = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off');
session_set_cookie_params([
    'lifetime' => 86400, 'path' => '/',
    'secure' => $secure, 'httponly' => true, 'samesite' => 'Lax',
]);
session_start();

$router = new \App\Core\Router();

// --- Auth ---
$router->add('GET',  '/api/csrf',                    'AuthController@csrf');
$router->add('POST', '/api/login',                   'AuthController@login');
$router->add('POST', '/api/logout',                  'AuthController@logout');
$router->add('GET',  '/api/me',                      'AuthController@me');
$router->add('POST', '/api/change-password',         'AuthController@changePassword');

// --- Files ---
$router->add('GET',  '/api/files',                   'FilesController@index');
$router->add('POST', '/api/files/init-upload',       'FilesController@initUpload');
$router->add('POST', '/api/files/complete-upload',   'FilesController@completeUpload');
$router->add('POST', '/api/files/{id}/rename',       'FilesController@rename');
$router->add('DELETE','/api/files/{id}',             'FilesController@delete');
$router->add('POST', '/api/files/{id}/share',        'FilesController@share');
$router->add('POST', '/api/files/{id}/restore',      'FilesController@restore');
$router->add('POST', '/api/files/{id}/move',          'FilesController@moveFile');
$router->add('GET',  '/api/files/{id}/download-url', 'FilesController@downloadUrl');
$router->add('GET',  '/api/files/{id}/preview-url',  'FilesController@previewUrl');

// --- Folders ---
$router->add('POST', '/api/folders',                 'FilesController@createFolder');
$router->add('POST', '/api/folders/{id}/rename',     'FilesController@renameFolder');
$router->add('DELETE','/api/folders/{id}',           'FilesController@deleteFolder');
$router->add('POST', '/api/folders/{id}/share',      'FilesController@shareFolder');
$router->add('POST', '/api/folders/{id}/restore',    'FilesController@restoreFolder');
$router->add('POST', '/api/folders/{id}/move',        'FilesController@moveFolderAction');

// --- Trash ---
$router->add('GET',  '/api/trash',                   'FilesController@trash');
$router->add('GET',  '/api/trash/count',             'FilesController@trashCount');
$router->add('POST', '/api/trash/empty',             'FilesController@emptyTrash');

// --- Usage ---
$router->add('GET',  '/api/usage',                   'FilesController@usage');

// --- Public share ---
$router->add('GET', '/s/{token}',                    'PublicController@show');
$router->add('GET', '/s/{token}/download',           'PublicController@download');
$router->add('GET', '/s/{token}/download/{fileId}',  'PublicController@downloadFolderFile');

// --- SPA ---
$router->add('GET', '/login',      'AppController@spa');
$router->add('GET', '/app',        'AppController@spa');
$router->add('GET', '/app/{any}',  'AppController@spa');
$router->add('GET', '/',           'AppController@root');

$router->dispatch();
